;NSIS Script For 

Page directory
Page components
Page instfiles
#UninstPage uninstConfirm
#UninstPage instfilesage directory

;Background Colors
BGGradient 0000FF 00AAFF FFFFFF
XPStyle on

;Title Of Your Application
Name "windows-ssh-tools"
SetCompressor lzma
CRCCheck On
OutFile "winsshtools.exe"

;The Default Installation Directory
InstallDir "$PROGRAMFILES\sshtools"

;The text to prompt the user to enter a directory
DirText "Please select the folder below"

Section "!Windows-OpenSSH Pageant compatibility application"
  SetOutPath $INSTDIR
  SetCompress Auto
  SetOverwrite IfNewer
  File wsl-ssh-pageant-amd64.exe
  File wsl-ssh-pageant-amd64-gui.exe

  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\sshtools" "DisplayName" "sshtools (remove only)"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\sshtools" "UninstallString" "$INSTDIR\Uninst.exe"
WriteUninstaller "Uninst.exe"
SectionEnd

Section "Autostart wsl-ssh-pageant"
  ;Add Shortcuts
  CreateDirectory "$SMPROGRAMS\sshtools"
  CreateShortCut "$SMSTARTUP\wsl-ssh-pageant.lnk" "$INSTDIR\wsl-ssh-pageant-amd64-gui.exe" "-systray -verbose -winssh ssh-agent" "$INSTDIR\wsl-ssh-pageant-amd64-gui.exe" 0

  ;CreateShortCut "$SMPROGRAMS\sshtools\T12cfg.lnk" "$INSTDIR\t12_gui.exe" "" "$INSTDIR\t12_gui.exe" 0
  ;CreateShortCut "$DESKTOP\sshtools.lnk" "$INSTDIR\t12_gui.exe" "" "$INSTDIR\t12_gui.exe" 0

  CreateShortCut "$SMPROGRAMS\sshtools\uninstall.lnk" "$INSTDIR\Uninst.exe" "" "$INSTDIR\Uninst.exe" 0
SectionEnd

Section "Set SSH_AUTH_SOCK environment variable"
  ; include for some of the windows messages defines
  !include "winmessages.nsh"
  ; HKLM (all users) vs HKCU (current user) defines
  !define env_hklm 'HKLM "SYSTEM\CurrentControlSet\Control\Session Manager\Environment"'
  !define env_hkcu 'HKCU "Environment"'
  ; set variable for local machine
  WriteRegExpandStr ${env_hklm} SSH_AUTH_SOCK "\\.\pipe\ssh-pageant"
  ; and current user
  WriteRegExpandStr ${env_hkcu} SSH_AUTH_SOCK "\\.\pipe\ssh-pageant"
  ; make sure windows knows about the change
  SendMessage ${HWND_BROADCAST} ${WM_WININICHANGE} 0 "STR:Environment" /TIMEOUT=5000
SectionEnd

Section /o "WinSCP and PuTTY wrappers for server certificates (requires PowerShell)"
  SetOutPath $INSTDIR
  File *.ps1

;  CreateShortCut "$SMPROGRAMS\T12cfg\T12cfg_transcript.lnk" \
;      "$SYSDIR\WindowsPowerShell\v1.0\powershell.exe" \
;      '-ExecutionPolicy Bypass -File "$INSTDIR\transcript.ps1"' \
;      "$SYSDIR\WindowsPowerShell\v1.0\powershell.exe" \
;      0
SectionEnd

UninstallText "This will uninstall Windows-SSH-tools from your system"

Section Uninstall
  ;Delete Start Menu Shortcuts
  ; Delete "$SMPROGRAMS\T12cfg\*.*"
  ; RmDir "$SMPROGRAMS\T12cfg"
  ; Delete "$DESKTOP\T12cfg.lnk"
  Delete "$SMSTARTUP\wsl-ssh-pageant.lnk"

  ;Delete Uninstaller And Unistall Registry Entries
  Delete "$INSTDIR\Uninst.exe"
  DeleteRegKey HKEY_LOCAL_MACHINE "SOFTWARE\sshtools"
  DeleteRegKey HKEY_LOCAL_MACHINE "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\sshtools"

  ;Delete program directory
  RMDir /r "$INSTDIR"
SectionEnd
